/*
 * Decompiled with CFR 0.152.
 */
package agent.mass;

import agent.base.AgentEvent;
import agent.mass.ConflictListener;
import agent.mass.ConflictRecord;
import agent.mass.ConflictResolution;
import agent.mass.ScheduleErrorException;
import agent.mass.Scheduler;
import agent.mass.SimpleTaemsReader;
import agent.mass.TaemsAction;
import agent.simplest.Action;
import agent.simplest.ActionEvent;
import agent.simplest.Communicate;
import agent.simplest.MessageEvent;
import agent.simplest.MessageEventListener;
import agent.simplest.Observe;
import agent.simplest.Observer;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.State;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import taems.Interrelationship;
import taems.Method;
import taems.Node;
import taems.Outcome;
import taems.Schedule;
import taems.ScheduleElement;
import taems.Taems;
import utilities.Distribution;
import utilities.KQMLMessage;
import utilities.Message;
import utilities.SafeEnumeration;

public class Execute
extends agent.simplest.Execute
implements MessageEventListener,
PropertyEventListener,
ConflictListener {
    static final long serialVersionUID = 1234567890L;
    protected State state;
    protected Communicate communicate;
    protected Scheduler scheduler;
    protected ConflictResolution conflicts;
    protected CachedResolutionResolver conflictcache;
    protected SimpleTaemsReader reader;
    private String laststatus;
    private boolean autoexec;
    private boolean seqexec;
    private boolean execmessages;
    public static final String DISPLAY = "Display";
    public static final String RUNDISPLAY = "RunDisplay";
    public static final String UPDATEDIST = "UpdateDist";
    public static final String AUTOEXECUTE = "AutoExecute";
    public static final String EXECUTIONMESSAGES = "ExecutionMessages";
    public static final String SEQUENTIALEXECUTION = "SequentialExecution";
    private static Class[] ta_cargs;

    public Execute() {
        this.addDependency("State");
        this.addDependency("Communicate");
        State.addParameterInfo(DISPLAY, "String", "URL to a picture of the agent.  This is used by Mass to show the agent when idle.");
        State.addParameterInfo(RUNDISPLAY, "String", "URL to a picture of the agent running.  This is used by Mass to show the agent when it is performing a method.");
        State.addParameterInfo(UPDATEDIST, "Boolean", "If true, Execute will update CQD distributions on a method when it completed", Boolean.TRUE);
        State.addParameterInfo(AUTOEXECUTE, "Boolean", "If true, Execute will automatically execute scheduled items.  The getSchedules function is used to find the schedules", Boolean.TRUE);
        State.addParameterInfo(EXECUTIONMESSAGES, "Boolean", "If true, send execution messages to the Mass simulator", Boolean.TRUE);
        State.addParameterInfo(SEQUENTIALEXECUTION, "Boolean", "When AutoExec is true, Execute will perform only one action at a time if this parameter is true", Boolean.FALSE);
    }

    public void init() {
        this.state = (State)State.findComponent("State");
        this.communicate = (Communicate)State.findComponent("Communicate");
        this.scheduler = (Scheduler)State.findComponent("Scheduler");
        this.conflicts = (ConflictResolution)State.findComponent("ConflictResolution");
        this.reader = (SimpleTaemsReader)State.findComponent("SimpleTaemsReader");
        this.communicate.addMessageEventListener(this);
        this.state.addPropertyEventListener(this);
        super.init();
        if (this.conflicts != null) {
            this.conflictcache = new CachedResolutionResolver();
            this.conflicts.addResolver(this.conflictcache);
        }
        if (State.hasComponent("Observe")) {
            Observe observe = (Observe)State.findComponent("Observe");
            observe.addObserver(new Observer("Deadlined Methods"){

                public boolean checkEvent(AgentEvent e) {
                    return e instanceof ActionEvent && e.getID() == 1 && ((ActionEvent)e).getAction() instanceof TaemsAction;
                }

                public void addEvent(AgentEvent e) {
                    TaemsAction a;
                    if (this.checkEvent(e) && (a = (TaemsAction)((ActionEvent)e).getAction()).getMethod().getDeadline() >= 0) {
                        this.updateCount(1.0);
                    }
                }
            });
            observe.addObserver(new Observer("Failed Deadlined Methods"){

                public boolean checkEvent(AgentEvent e) {
                    return e instanceof ActionEvent && e.getID() == 1 && ((ActionEvent)e).getAction() instanceof TaemsAction;
                }

                public void addEvent(AgentEvent e) {
                    TaemsAction a;
                    int deadline;
                    if (this.checkEvent(e) && (deadline = (a = (TaemsAction)((ActionEvent)e).getAction()).getMethod().getDeadline()) >= 0 && a.getMethod().getActualLatestFinishTime() < a.getFinish()) {
                        this.updateCount(1.0);
                    }
                }
            });
        }
    }

    public void pulse() {
        boolean gotone = false;
        Enumeration e = this.actions.elements();
        while (e.hasMoreElements()) {
            Action a = (Action)e.nextElement();
            if (a.getData("Local") != null && a.isDone() && a.getData("NoMessage") == null && this.execmessages) {
                Object[] rsrc = (Object[])a.getData("Resources");
                String rsrcstr = "";
                if (rsrc != null) {
                    rsrcstr = rsrcstr + "Used ";
                    for (int i = 0; i < rsrc.length; ++i) {
                        rsrcstr = rsrcstr + rsrc[i].toString() + " " + rsrc[++i].toString() + " ";
                    }
                }
                KQMLMessage message = new KQMLMessage("ask", (Object)("(ExecuteEnd " + a.getName() + " " + a.getTime() + " " + a.getCost() + " " + a.getQuality() + " " + rsrcstr + ")"), "simulator");
                message.addField("reply-with", Long.toString(a.getID()));
                message.addField("type", "control");
                this.communicate.sendMessage((Message)message);
                continue;
            }
            if (a.getData("Local") == null && this.execmessages || !a.isDone()) continue;
            this.log.log("Completing action " + a.getName(), 2, this.FAC_EXECUTE);
            this.completeAction(a);
        }
        if (!(!this.autoexec || this.seqexec && this.isExecuting())) {
            Schedule sched;
            int time = (Integer)this.state.getProperty("Time");
            this.handleLateActions();
            e = this.getSchedules();
            while (!(!e.hasMoreElements() || (gotone |= this.runSchedule(sched = (Schedule)e.nextElement()) > 0) && this.seqexec)) {
            }
            if (!gotone) {
                this.log.log("No new tasks available for Execute to perform", 5, this.FAC_EXECUTE);
            }
        } else if (!this.autoexec) {
            this.log.log("Autoexecution is not enabled", 5, this.FAC_EXECUTE);
        }
        super.pulse();
    }

    public void handleLateActions() {
        float offset;
        TaemsAction ta;
        ScheduleElement se;
        Action a;
        int time = (Integer)this.state.getProperty("Time");
        this.log.log("Execute searching for actions that are taking too long", 3, this.FAC_EXECUTE);
        Enumeration e = this.actions();
        while (e.hasMoreElements()) {
            a = (Action)e.nextElement();
            if (!(a instanceof TaemsAction) || (se = (ta = (TaemsAction)a).getScheduleElement()) == null || !(se.getFinishTime().calculateMax() <= (float)time)) continue;
            offset = time - se.getFinish() + 1;
            if (this.scheduler == null) continue;
            this.log.log("Delaying schedule element resources " + se.getLabel() + " for " + offset + " clicks", 3, this.FAC_EXECUTE);
            this.scheduler.updateResourceModeler(se, (int)offset);
        }
        e = this.actions();
        while (e.hasMoreElements()) {
            a = (Action)e.nextElement();
            if (!(a instanceof TaemsAction)) continue;
            ta = (TaemsAction)a;
            se = ta.getScheduleElement();
            if (se != null) {
                if (se.getFinishTime().calculateMax() <= (float)time) {
                    offset = time - se.getFinish() + 1;
                    this.log.log("Delaying schedule element finish " + se.getLabel() + " for " + offset + " clicks", 3, this.FAC_EXECUTE);
                    if (this.scheduler != null) {
                        this.log.log("Using scheduler to delay schedule element finish from " + se.getFinishTime().calculateMax() + " to " + (time + 1), 4, this.FAC_EXECUTE);
                        try {
                            this.scheduler.delayFinishTime(ta.getSchedule(), se, (int)offset);
                        }
                        catch (ScheduleErrorException see) {
                            this.log.log("Warning, could not delay schedule element finish " + se.getLabel() + " to time " + (int)(offset + (float)time) + ": " + see, 1, this.FAC_EXECUTE);
                        }
                        continue;
                    }
                    if (ta.getSchedule() != null) {
                        this.log.log("Using schedule method to delay schedule element finish from " + se.getFinishTime().calculateMax() + " to " + (time + 1), 4, this.FAC_EXECUTE);
                        ta.getSchedule().delayFinishTime(se, (int)offset);
                        continue;
                    }
                    this.log.log("Sorry, I can't find a way to delay schedule element finish time", 1, this.FAC_EXECUTE);
                    continue;
                }
                if (this.log.getLogLevel(this.FAC_EXECUTE) < 4) continue;
                this.log.log("Schedule element " + se.getLabel() + " is ok with maximum finish time of " + se.getFinishTime().calculateMax(), 4, this.FAC_EXECUTE);
                continue;
            }
            this.log.log("Cannot check lateness on action " + a.getName() + ", no schedule element found", 3, this.FAC_EXECUTE);
        }
    }

    public int runSchedule(Schedule schedule) {
        int time = (Integer)this.state.getProperty("Time");
        Vector<ScheduleElement> runnable = new Vector<ScheduleElement>();
        if (schedule == null) {
            return 0;
        }
        this.log.log("Looking for things to run in schedule containing " + schedule.size() + " elements", 3, this.FAC_EXECUTE);
        SafeEnumeration e = new SafeEnumeration(schedule.getNextTasks(time));
        while (e.hasMoreElements()) {
            ScheduleElement t = (ScheduleElement)e.nextElement();
            this.log.log("Evaluating the runability of schedule element " + t.getLabel(), 3, this.FAC_EXECUTE);
            if (t.getStart() < time) {
                float offset = time - t.getStart();
                this.log.log("Delaying schedule element " + t.getLabel() + " for " + offset + " clicks", 3, this.FAC_EXECUTE);
                if (this.scheduler != null) {
                    this.log.log("Using scheduler to delay schedule element start from " + t.getStart() + " to " + time, 4, this.FAC_EXECUTE);
                    try {
                        this.scheduler.delayStartTime(schedule, t, (int)offset);
                    }
                    catch (ScheduleErrorException see) {
                        this.log.log("Warning, could not delay schedule element start " + t.getLabel() + " to time " + (int)(offset + (float)time) + ": " + see, 1, this.FAC_EXECUTE);
                        return 0;
                    }
                } else {
                    this.log.log("Using schedule method to delay schedule element start from " + t.getStart() + " to " + time, 4, this.FAC_EXECUTE);
                    schedule.delayStartTime(t, (int)offset);
                }
                this.log.log("New start time for " + t.getLabel() + ": " + t.getStart(), 3, this.FAC_EXECUTE);
            }
            if (t.getStart() <= time) {
                runnable.addElement(t);
                if (!this.seqexec) continue;
                this.log.log("We're using sequential execution, so I'm just going to stop here", 3, this.FAC_EXECUTE);
                break;
            }
            this.log.log("Whoops, it's too early to execute " + t.getLabel(), 3, this.FAC_EXECUTE);
        }
        Iterator i = runnable.iterator();
        while (i.hasNext()) {
            ScheduleElement t = (ScheduleElement)i.next();
            this.log.log("Performing final precondition check for " + t.getLabel(), 3, this.FAC_EXECUTE);
            if (t.checkPreconditions(time)) continue;
            this.log.log("Schedule element " + t.getLabel() + " no longer passes all preconditions", 3, this.FAC_EXECUTE);
            i.remove();
        }
        i = runnable.iterator();
        while (i.hasNext()) {
            Action a;
            ScheduleElement t;
            block19: {
                t = (ScheduleElement)i.next();
                if (t.getMethod().hasAttribute((Object)"Action")) {
                    String name = (String)t.getMethod().getAttribute((Object)"Action");
                    this.log.log("Trying to dynamically create action " + name, 3, this.FAC_EXECUTE);
                    try {
                        Class<?> c = Class.forName(name);
                        try {
                            Constructor<?> con = c.getDeclaredConstructor(ta_cargs);
                            this.log.log("Using TaemsAction two param style constructor", 4, this.FAC_EXECUTE);
                            Object[] args = new Object[]{t, schedule};
                            a = (Action)con.newInstance(args);
                        }
                        catch (Exception ex) {
                            this.log.log("Using zero param style constructor", 4, this.FAC_EXECUTE);
                            a = (Action)c.newInstance();
                        }
                        break block19;
                    }
                    catch (ClassNotFoundException ex) {
                        this.log.log("Error: Class " + name + " was not found\n" + ex.toString(), 0, this.FAC_EXECUTE);
                        continue;
                    }
                    catch (InstantiationException ex) {
                        this.log.log("Error: Class " + name + " could not be instantiated\n" + ex.toString(), 0, this.FAC_EXECUTE);
                        continue;
                    }
                    catch (IllegalAccessException ex) {
                        this.log.log("Error: Class " + name + " could not be instantiated\n" + ex.toString(), 0, this.FAC_EXECUTE);
                        continue;
                    }
                    catch (ClassCastException ex) {
                        this.log.log("Error: Class " + name + " does not appear to be an Action\n" + ex.toString(), 0, this.FAC_EXECUTE);
                        continue;
                    }
                }
                a = new TaemsAction(t, schedule);
            }
            if (a != null) {
                this.executeAction(a);
                continue;
            }
            this.log.log("Error: Action for schedule element " + t.getLabel() + " was null", 0, this.FAC_EXECUTE);
        }
        this.log.log("Done looking at schedule, " + runnable.size() + " elements executed", 3, this.FAC_EXECUTE);
        return runnable.size();
    }

    public void executeAction(Action a) {
        Object newdisp;
        boolean update;
        KQMLMessage reply = null;
        if (a instanceof TaemsAction) {
            TaemsAction ta = (TaemsAction)a;
            Method method = ta.getMethod();
            method.setStatus(1);
            if (method.isNonLocal()) {
                a.setData("NonLocal", "true");
            }
            if (ta.getMethod().isVirtual()) {
                this.log.log("Warning: Executing action " + a.getName() + " is virtual", 1, this.FAC_EXECUTE);
            }
        }
        if (a.getData("NonLocal") == null && a.getData("NoMessage") == null) {
            reply = a.getData("Local") != null ? new KQMLMessage("ask", (Object)("(ExecuteReal " + a.getName() + ")"), "simulator") : new KQMLMessage("ask", (Object)("(ExecuteStart " + a.getName() + ")"), "simulator");
        }
        if (reply != null && this.execmessages) {
            reply.addField("reply-with", Long.toString(a.getID()));
            this.communicate.sendMessage((Message)reply);
        }
        super.executeAction(a);
        boolean bl = update = !this.isExecuting();
        if (update && (newdisp = this.state.getProperty(RUNDISPLAY)) != null) {
            this.state.setProperty("TempDisplay", this.state.getProperty(DISPLAY));
            this.state.setProperty(DISPLAY, newdisp);
        }
    }

    public void completeAction(Action a) {
        Object newdisp;
        Method method = null;
        if (a instanceof TaemsAction) {
            TaemsAction ta = (TaemsAction)a;
            method = ta.getMethod();
        }
        if (method == null) {
            Taems task;
            this.log.log("Searching for completed method: " + a.getName(), 3, this.FAC_EXECUTE);
            Enumeration e = this.getTaems();
            while (e.hasMoreElements() && (method = (Method)(task = (Taems)e.nextElement()).findNode((Node)new Method(a.getName(), null))) == null) {
            }
        }
        if (method != null && method.isVirtual()) {
            this.log.log("Warning: Completed action " + method.getLabel() + " references a virtual method", 1, this.FAC_EXECUTE);
        }
        if (a.getFinish() < 0) {
            a.setFinish((Integer)this.state.getProperty("Time"));
        }
        if (method != null) {
            this.log.log("Completing method:\n" + method.toString(), 5, this.FAC_EXECUTE);
            if (this.log.getLogLevel(this.FAC_EXECUTE) >= 3) {
                Outcome o = method.getGlobalOutcome();
                if (o != null) {
                    Distribution outs = o.getDuration();
                    if (outs.containsValue((float)a.getDuration(), 0.05f)) {
                        this.log.log("Action " + a.getName() + " duration of " + a.getDuration() + " fell in " + outs, 3, this.FAC_EXECUTE);
                    } else {
                        this.log.log("Action " + a.getName() + " duration of " + a.getDuration() + " fell outside " + outs, 3, this.FAC_EXECUTE);
                    }
                } else {
                    this.log.log("Warning: method " + method.getLabel() + " has no global outcome", 1, this.FAC_EXECUTE);
                }
            }
            if (this.state.hasProperty(UPDATEDIST) && ((Boolean)this.state.getProperty(UPDATEDIST)).booleanValue()) {
                method.removeAllOutcomes();
                method.addOutcome(new Outcome("Final_Results", new Distribution(new Float(a.getQuality()), new Float(1.0)), new Distribution(new Float(a.getDuration()), new Float(1.0)), new Distribution(new Float(a.getCost()), new Float(1.0)), 1.0f));
            }
            method.setStatus(2);
        } else if (a instanceof TaemsAction) {
            this.log.log("Error: The completed method " + a.getName() + " could not be found", 0, this.FAC_EXECUTE);
        }
        super.completeAction(a);
        this.checkConflicts(method);
        if (!this.isExecuting() && (newdisp = this.state.getProperty("TempDisplay")) != null) {
            this.state.setProperty(DISPLAY, newdisp);
        }
    }

    public void checkConflicts(Method m) {
        ConflictRecord cr;
        Taems taems;
        Vector v;
        if (this.conflicts == null || this.reader == null || m == null) {
            return;
        }
        if (m.hasFinished() && m.getCurrentQuality() <= 0.0f && !(v = this.conflicts.conflictRequest(new ConflictRecord((ConflictListener)this, taems = this.reader.findTaems((Node)m)))).isEmpty() && (cr = (ConflictRecord)v.firstElement()).getTaems() != null) {
            this.log.log("Replacing current task structure with the one provided by " + cr.getSource().toString(), 2, this.FAC_EXECUTE);
            this.conflictcache.addResolution(taems, cr);
            this.reader.removeTaems(taems);
            this.reader.storeTaems(SimpleTaemsReader.CONTAEMS, cr.getTaems());
        }
    }

    public Action statusAction(Action a) {
        int timeout = 5;
        if (!this.execmessages) {
            this.log.log("Warning: statusAction does not function without ExecutionMessages", 1, this.FAC_EXECUTE);
            return a;
        }
        this.laststatus = null;
        KQMLMessage message = new KQMLMessage("ask", (Object)("(status " + a.getName() + ")"), "simulator");
        message.addField("reply-with", Long.toString(a.getID()));
        this.communicate.sendMessage((Message)message);
        timeout *= 10;
        while (this.laststatus == null) {
            if (--timeout <= 0) {
                this.log.log("Timeout waiting for action status (" + a.getName() + ") reply from simulator", 0, this.FAC_EXECUTE);
                break;
            }
            this.communicate.receiveMessage();
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        a.setData("Update", this.state.getProperty("Time"));
        if (this.laststatus == null) {
            a.setData("Status", "Unknown");
        } else {
            Object[] rsrc;
            StringTokenizer tok = new StringTokenizer(this.laststatus, ":");
            tok.nextToken();
            a.setData("Status", tok.nextToken());
            a.setCost(Float.valueOf(tok.nextToken()).floatValue());
            a.setQuality(Float.valueOf(tok.nextToken()).floatValue());
            a.setTime(Integer.parseInt(tok.nextToken()) * -1);
            if (tok.countTokens() > 0) {
                rsrc = new Object[tok.countTokens() - 1];
                tok.nextToken();
                int i = 0;
                while (tok.hasMoreTokens()) {
                    rsrc[i] = tok.nextToken();
                    rsrc[++i] = Float.valueOf(tok.nextToken());
                    ++i;
                }
            } else {
                rsrc = new Object[]{};
            }
            a.setData("Resources", rsrc);
        }
        return a;
    }

    public boolean extendAction(Action a, int i) {
        if (!this.execmessages) {
            this.log.log("Warning: extendAction does not function without ExecutionMessages", 1, this.FAC_EXECUTE);
            return false;
        }
        this.log.log("Trying to extend action " + a + " by" + i + " clicks", 1, this.FAC_EXECUTE);
        KQMLMessage message = new KQMLMessage("error", (Object)("(ExecuteExtend " + i + " " + a.getName() + ")"), "simulator");
        message.addField("reply-with", Long.toString(a.getID()));
        this.communicate.sendMessage((Message)message);
        return true;
    }

    public boolean cancelAction(Action a, String reason) {
        if (!this.execmessages) {
            this.log.log("Warning: cancelAction does not function without ExecutionMessages", 1, this.FAC_EXECUTE);
            return super.cancelAction(a, reason);
        }
        this.log.log("Trying to cancel action " + a + " (" + reason + ")", 1, this.FAC_EXECUTE);
        KQMLMessage message = new KQMLMessage("error", (Object)("(Abort " + a.getName() + ")"), "simulator");
        message.addField("reply-with", Long.toString(a.getID()));
        this.communicate.sendMessage((Message)message);
        return true;
    }

    protected boolean finishCancelAction(Action a, String reason) {
        Object newdisp;
        TaemsAction ta;
        boolean status = false;
        Method method = null;
        boolean anytime = false;
        if (a == null) {
            return false;
        }
        if (a instanceof TaemsAction && (method = (ta = (TaemsAction)a).getMethod()).hasAttribute((Object)"ExecutionType") && ((String)method.getAttribute((Object)"ExecutionType")).equalsIgnoreCase("anytime")) {
            anytime = true;
        }
        if (!anytime) {
            this.log.log("Setting quality of aborted action " + a.getName() + " to zero.", 3, this.FAC_EXECUTE);
            a.setQuality(0.0f);
        }
        if (method == null) {
            Taems task;
            Enumeration e = this.getTaems();
            while (e.hasMoreElements() && (method = (Method)(task = (Taems)e.nextElement()).findNode((Node)new Method(a.getName(), null))) == null) {
            }
        }
        if (a.getFinish() < 0) {
            a.setFinish((Integer)this.state.getProperty("Time"));
        }
        if (method != null) {
            if (this.state.hasProperty(UPDATEDIST) && ((Boolean)this.state.getProperty(UPDATEDIST)).booleanValue()) {
                method.removeAllOutcomes();
                method.addOutcome(new Outcome("Final_Results", new Distribution(new Float(a.getQuality()), new Float(1.0)), new Distribution(new Float(a.getDuration()), new Float(1.0)), new Distribution(new Float(a.getCost()), new Float(1.0)), 1.0f));
            }
            method.setStatus(2);
        }
        if (status = this.actions.removeElement(a)) {
            status = super.finishCancelAction(a, reason);
            if (status) {
                this.log.log("Action " + a + " cancelled", 2, this.FAC_EXECUTE);
            } else {
                this.log.log("Action " + a + " not cancelled", 1, this.FAC_EXECUTE);
            }
        } else {
            this.log.log("Error: Tried to cancel an action I don't know about", 0, this.FAC_EXECUTE);
        }
        if (!this.isExecuting() && (newdisp = this.state.getProperty("TempDisplay")) != null) {
            this.state.setProperty(DISPLAY, newdisp);
        }
        return status;
    }

    public boolean isDone() {
        if (!super.isDone()) {
            return false;
        }
        Enumeration e = this.getSchedules();
        while (e.hasMoreElements()) {
            Schedule s = (Schedule)e.nextElement();
            if (s.isCompleted()) continue;
            return false;
        }
        return true;
    }

    public void overrideActionStatus(Action a) {
        if (!this.execmessages) {
            return;
        }
        KQMLMessage message = new KQMLMessage("tell", (Object)("(ExecuteSet " + a.getName() + " " + a.getStart() + " " + a.getFinish() + " " + a.getCost() + " " + a.getQuality() + " " + ")"), "simulator");
        message.addField("type", "control");
        this.communicate.sendMessage((Message)message);
    }

    public Vector conflictRequest(ConflictRecord cr) {
        return null;
    }

    public void conflictResponse(ConflictRecord cr) {
    }

    public int getResolverPriority() {
        return 0;
    }

    public void messageReceived(MessageEvent me) {
        if (me.getConnection().getType() != 1) {
            return;
        }
        KQMLMessage m = (KQMLMessage)me.getMessage();
        String perf = m.getPerformative();
        String type = m.getField("type");
        if (type == null) {
            type = "";
        }
        if (type.equalsIgnoreCase("control") && perf.equalsIgnoreCase("reply") && this.findAction(m.contentWord()) != null) {
            this.laststatus = m.contentData();
        }
        if (perf.equalsIgnoreCase("tell") && m.contentWord().startsWith("ActivateInterrelationship")) {
            int time = (Integer)this.state.getProperty("Time");
            StringTokenizer s = new StringTokenizer(m.contentData());
            if (s.countTokens() != 2) {
                this.log.log("Error: Interrelationship message \"" + m.getContent() + "\" does not appear to be valid", 0, this.FAC_EXECUTE);
                return;
            }
            String irName = s.nextToken();
            int delay = Integer.parseInt(s.nextToken());
            Interrelationship match = new Interrelationship(irName, null, null, null, null, null);
            Interrelationship ir = null;
            Enumeration e = this.getTaems();
            while (e.hasMoreElements()) {
                Taems taems = (Taems)e.nextElement();
                try {
                    ir = (Interrelationship)taems.findNode((Node)match);
                }
                catch (ClassCastException ex) {
                    ir = null;
                }
                if (ir == null) continue;
                break;
            }
            if (ir == null) {
                this.log.log("Interrelationship (" + irName + ") could not be found.", 0, this.FAC_EXECUTE);
            } else {
                this.log.log("Updating interrelationship " + ir.getLabel() + ".", 3, this.FAC_EXECUTE);
                ir.setActive(true);
                if (this.state.hasProperty(UPDATEDIST) && ((Boolean)this.state.getProperty(UPDATEDIST)).booleanValue()) {
                    Distribution d = new Distribution(new Float(delay), new Float(1.0));
                    ir.setDelay(d);
                }
            }
        }
        if (perf.equalsIgnoreCase("reply") || perf.equalsIgnoreCase("tell")) {
            if (m.contentWord().startsWith("ExecuteEnd") || m.contentWord().startsWith("ExecuteAbort")) {
                Object[] rsrc;
                int duration;
                String id = m.getField("in-reply-to");
                Action action = perf.equalsIgnoreCase("tell") ? this.findAction(id) : this.findAction(Long.parseLong(id));
                if (action == null) {
                    this.log.log("Error: Could not find action matching id " + id, 0, this.FAC_EXECUTE);
                    return;
                }
                this.log.log("Execte termination message received for " + action, 4, this.FAC_EXECUTE);
                action.setData("Source", m.getSourceAddr());
                int time = (Integer)this.state.getProperty("Time");
                StringTokenizer s = new StringTokenizer(m.contentData());
                if (s.countTokens() < 4) {
                    this.log.log("Error: Execute message \"" + m.getContent() + "\" does not appear to be valid", 0, this.FAC_EXECUTE);
                    return;
                }
                String methodName = s.nextToken();
                int dumdur = (int)Float.parseFloat(s.nextToken());
                if (dumdur != (duration = time - action.getStart())) {
                    this.log.log("Given duration (" + dumdur + ") does not match observed (" + duration + ")", 1, this.FAC_EXECUTE);
                }
                float cost = Float.valueOf(s.nextToken()).floatValue();
                float quality = Float.valueOf(s.nextToken()).floatValue();
                if (s.countTokens() > 0) {
                    rsrc = new Object[s.countTokens() - 1];
                    s.nextToken();
                    int i = 0;
                    while (s.hasMoreTokens()) {
                        rsrc[i] = s.nextToken();
                        rsrc[++i] = Float.valueOf(s.nextToken());
                        ++i;
                    }
                } else {
                    rsrc = new Object[]{};
                }
                if (action != null) {
                    action.setCost(cost);
                    action.setQuality(quality);
                    action.setTime(0);
                    action.setData("Resources", rsrc);
                } else {
                    this.log.log("Error: action id " + id + " not known to us.", 0, this.FAC_EXECUTE);
                }
                if (m.contentWord().startsWith("ExecuteAbort")) {
                    this.finishCancelAction(action, "Abort");
                } else {
                    this.completeAction(action);
                }
            }
        } else if (perf.equalsIgnoreCase("error") && m.contentWord().startsWith("ExecuteError")) {
            StringTokenizer s = new StringTokenizer(m.contentData());
            String name = s.nextToken();
            this.log.log("Error: " + m.contentData(), 0, this.FAC_EXECUTE);
            long id = Long.parseLong(m.getField("in-reply-to"));
            Action a = this.findAction(id);
            a.setQuality(0.0f);
            a.setCost(0.0f);
            this.finishCancelAction(a, "Error");
        }
    }

    public void messageSent(MessageEvent m) {
    }

    protected Enumeration getTaems() {
        if (this.state.hasProperty(SimpleTaemsReader.CONTAEMS)) {
            Object o = this.state.getProperty(SimpleTaemsReader.CONTAEMS);
            if (o instanceof Taems) {
                Vector<Object> v = new Vector<Object>(1);
                v.addElement(o);
                return v.elements();
            }
            if (o instanceof Hashtable) {
                return new SafeEnumeration(((Hashtable)o).elements());
            }
        } else if (this.state.hasProperty(SimpleTaemsReader.SUBTAEMS)) {
            Object o = this.state.getProperty(SimpleTaemsReader.SUBTAEMS);
            if (o instanceof Taems) {
                Vector<Object> v = new Vector<Object>(1);
                v.addElement(o);
                return v.elements();
            }
            if (o instanceof Hashtable) {
                return new SafeEnumeration(((Hashtable)o).elements());
            }
        }
        return new Vector(0).elements();
    }

    protected Enumeration getSchedules() {
        Vector<Object> v = new Vector<Object>();
        if (this.state.hasProperty("Schedule") && this.state.getProperty("Schedule") instanceof Schedule) {
            this.log.log("Looking in master schedule", 4, this.FAC_EXECUTE);
            v.addElement(this.state.getProperty("Schedule"));
        } else {
            Enumeration en = this.getTaems();
            while (en.hasMoreElements()) {
                Taems task = (Taems)en.nextElement();
                this.log.log("Looking for schedule in structure " + task.getLabel(), 4, this.FAC_EXECUTE);
                Schedule sched = task.getFirstSchedule();
                if (sched == null) continue;
                v.addElement(sched);
            }
        }
        return v.elements();
    }

    public void propertyChanged(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equalsIgnoreCase("SubTaemsTask")) {
            if (this.isExecuting()) {
                this.log.log("A new task structure has arrived, but I'm not cancelling your actions", 3, this.FAC_EXECUTE);
            }
        } else if (key.equalsIgnoreCase(AUTOEXECUTE)) {
            this.autoexec = (Boolean)e.getProperty();
        } else if (key.equalsIgnoreCase(SEQUENTIALEXECUTION)) {
            this.seqexec = (Boolean)e.getProperty();
        } else if (key.equalsIgnoreCase(EXECUTIONMESSAGES)) {
            this.execmessages = (Boolean)e.getProperty();
        }
    }

    public void propertyRemoved(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }

    static {
        try {
            ta_cargs = new Class[2];
            Execute.ta_cargs[0] = Class.forName("taems.ScheduleElement");
            Execute.ta_cargs[1] = Class.forName("taems.Schedule");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public class CachedResolutionResolver
    implements ConflictListener {
        public Hashtable cache = new Hashtable();

        public int getResolverPriority() {
            return 9;
        }

        public Vector conflictRequest(ConflictRecord cr) {
            String key;
            Vector<Object> results = new Vector<Object>();
            if (cr.getType() == 0 && cr.getTaems() != null && this.cache.containsKey(key = this.generateKey(cr.getTaems()))) {
                results.add(((Taems)this.cache.get(key)).clone());
            }
            return results;
        }

        public void conflictResponse(ConflictRecord cr) {
        }

        public void addResolution(Taems t, ConflictRecord cr) {
            String key = this.generateKey(t);
            this.cache.put(key, (Taems)cr.getTaems().clone());
            Execute.this.log.log("Added conflict resolution cache for " + key, 3, Execute.this.FAC_EXECUTE);
        }

        protected String generateKey(Taems taems) {
            StringBuffer buf = new StringBuffer();
            buf.append(Execute.this.scheduler.generateCacheKey(taems).toString());
            buf.append(this.generateScheduleKey(taems));
            return buf.toString();
        }

        protected String generateScheduleKey(Taems taems) {
            StringBuffer buf = new StringBuffer();
            Enumeration e = taems.getFirstSchedule().getElements();
            while (e.hasMoreElements()) {
                ScheduleElement elem = (ScheduleElement)e.nextElement();
                buf.append(elem.getLabel());
                if (!elem.getMethod().hasFinished()) continue;
                buf.append(String.valueOf(elem.getMethod().getCurrentQuality()));
            }
            return buf.toString();
        }
    }
}

