/*
 * Decompiled with CFR 0.152.
 */
package agent.mass;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import utilities.Converter;
import utilities.Log;
import utilities.UTimer;

public class DTCNative {
    static boolean using_native = false;
    static boolean library_loaded = false;
    static boolean silent = false;
    static DTCNative nat;
    private static String[] temp_args;
    private static String temp_ttaems;
    static int count;
    static boolean printed;

    public DTCNative() {
        if (!library_loaded) {
            boolean useit = false;
            if (System.getProperty("UseDTCNative") != null) {
                Boolean b = (Boolean)Converter.reTypeProperty((String)System.getProperty("UseDTCNative"), (String)"Boolean");
                useit = b;
            }
            if (useit) {
                String libname = System.getProperty("DTCLibName");
                try {
                    if (libname == null) {
                        libname = "/usr/maslocal/lib/libdtc-java.so";
                    }
                    System.load(libname);
                    library_loaded = true;
                    using_native = true;
                    if (!silent) {
                        this.log("Native DTC library succesfully loaded.", 2);
                    }
                }
                catch (Throwable e) {
                    try {
                        if (libname == null) {
                            libname = "dtc-java-linux";
                        }
                        this.log("Loading DTC library failed, trying again with " + libname, 1);
                        System.loadLibrary(libname);
                        library_loaded = true;
                        using_native = true;
                        if (!silent) {
                            this.log("Native DTC library succesfully loaded.", 2);
                        }
                    }
                    catch (Throwable f) {
                        if (!silent) {
                            this.log("loading DTC library failed, falling back on exec call...", 1);
                        }
                        library_loaded = false;
                        using_native = false;
                    }
                }
            } else {
                if (!silent) {
                    this.log("Not using native DTC library calls.", 2);
                }
                library_loaded = false;
                using_native = false;
            }
        }
    }

    public void log(String s, int l) {
        Log.getDefault().log(s, l);
    }

    public static boolean isNativeAvailable() {
        return using_native;
    }

    public native void call_dtc_normal(String[] var1);

    public native String call_dtc(int var1, String var2, int var3, int var4, int var5, String var6, boolean var7);

    public String call_dtc(int numschedules, String ttaems) {
        return this.call_dtc(numschedules, "p", 50, 100, 0, ttaems, false);
    }

    public static void main(String[] args) {
        System.setProperty("UseDTCNative", "true");
        System.setProperty("DTCLibName", "libdtc-java");
        silent = false;
        nat = new DTCNative();
        temp_args = args;
        try {
            String ttaems;
            FileReader reader = new FileReader(args[0]);
            BufferedReader br = new BufferedReader(reader);
            StringBuffer buf = new StringBuffer();
            while (br.ready()) {
                buf.append(br.readLine());
                buf.append("\n");
            }
            temp_ttaems = ttaems = buf.toString();
            printed = false;
            UTimer.time((int)count, (UTimer)new UTimer("dtc complex native call"){

                public void action() {
                    String result = nat.call_dtc(15, "p", 50, 100, 0, temp_ttaems, false);
                }
            }, (boolean)true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        UTimer.time((int)count, (UTimer)new UTimer("dtc exec call"){

            public void action() {
                String cmd = "/nfs/ymir/u0/rawlins/bin/dtc-test ";
                for (int i = 0; i < temp_args.length; ++i) {
                    cmd = cmd + temp_args[i] + " ";
                }
                try {
                    Process sched = Runtime.getRuntime().exec(cmd);
                    sched.waitFor();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, (boolean)true);
    }

    static {
        count = 200;
        printed = false;
    }
}

