/*
 * Decompiled with CFR 0.152.
 */
package agent.mass;

import agent.mass.Communicate;
import agent.mass.State;
import agent.simplest.MessageEvent;
import agent.simplest.MessageEventListener;
import utilities.KQMLMessage;
import utilities.Message;

public class Control
extends agent.simplest.Control
implements MessageEventListener {
    static final long serialVersionUID = 1234567890L;
    protected Communicate communicate;
    int lpa = -1;

    public Control() {
        this.addDependency("Communicate");
        State.addParameterInfo("AutoPulse", null, null, Boolean.FALSE);
        State.addParameterInfo("AutoPulseDelay", null, null, new Integer(0));
    }

    public void init() {
        super.init();
        this.communicate = (Communicate)State.findComponent("Communicate");
        this.communicate.addMessageEventListener(this);
    }

    public void quit() {
        if (this.communicate != null && this.communicate.ready()) {
            KQMLMessage reply = new KQMLMessage("reply", (Object)"(ack disconnect)", "simulator");
            reply.addField("in-reply-to", "disconnect");
            this.communicate.sendMessage((Message)reply);
        } else {
            this.log.log("Cannot send disconnect to simulator - communicate not ready", 1, this.FAC_CTRL);
        }
        super.quit();
    }

    public void pulsePostprocess() {
        super.pulsePostprocess();
        this.sendPulseAcknowledgement();
    }

    public void waitForTime(int npt) {
        int time;
        this.log.log("Starting to wait for time " + npt, 2, this.FAC_CTRL);
        this.state.setProperty("NextPulseTime", new Integer(npt));
        this.sendPulseAcknowledgement();
        while ((time = ((Integer)this.state.getProperty("Time")).intValue()) < npt) {
            try {
                Thread.yield();
                Thread.currentThread();
                Thread.sleep(this.pulsedelay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void doPulse() {
        Integer time = (Integer)this.state.getProperty("Time");
        if (time == null) {
            time = new Integer(0);
        }
        time = new Integer(time + 1);
        this.log.log("Setting time to " + time, 2, this.FAC_CTRL);
        this.state.setProperty("Time", time);
        Integer npt = (Integer)this.state.getProperty("NextPulseTime");
        if (this.isPaused()) {
            this.log.log("Agent is paused, pulse avoided", 2, this.FAC_CTRL);
            this.sendExtendExecutions(1);
            this.sendPulseAcknowledgement();
        }
        if (npt == null || npt < time) {
            super.doPulse();
        } else if (npt > time) {
            this.log.log("NextPulseTime is " + npt + ", pulse avoided", 2, this.FAC_CTRL);
            this.sendExtendExecutions(1);
            this.sendPulseAcknowledgement();
        } else if (npt.intValue() == time.intValue()) {
            this.log.log("NextPulseTime is " + npt + ", pulse should be continuing", 2, this.FAC_CTRL);
        }
    }

    public void sendExtendExecutions(int i) {
        KQMLMessage reply = new KQMLMessage("error", (Object)("(ExecuteExtend " + i + ")"), "simulator");
        this.communicate.sendMessage((Message)reply);
    }

    public void sendPulseAcknowledgement() {
        int time = (Integer)this.state.getProperty("Time");
        if (time <= this.lpa) {
            return;
        }
        this.lpa = time;
        KQMLMessage reply = new KQMLMessage("reply", (Object)"(ack pulse)", "simulator");
        reply.addField("in-reply-to", "pulse");
        this.communicate.sendMessage((Message)reply);
    }

    public void messageSent(MessageEvent m) {
    }

    public void messageReceived(MessageEvent m) {
        if (m.getConnection().getType() != 1) {
            return;
        }
        String perf = ((KQMLMessage)m.getMessage()).getPerformative();
        String content = m.getMessage().contentWord();
        if (perf.equalsIgnoreCase("ask") && !content.equalsIgnoreCase("pulse")) {
            if (content.equalsIgnoreCase("reset")) {
                this.log.log("Reset message received", 1, this.FAC_CTRL);
                KQMLMessage reply = new KQMLMessage("reply", (Object)("(" + this.state.getProperty("Name") + ")"), m.getMessage().getSourceAddr());
                reply.addField("in-reply-to", "reset");
                this.communicate.sendMessage((Message)reply);
                this.resetComponents();
            } else if (content.equalsIgnoreCase("disconnect")) {
                this.log.log("Disconnect message received", 1, this.FAC_CTRL);
                this.quit();
            }
        }
    }
}

