/*
 * Decompiled with CFR 0.152.
 */
package agent.mass;

import agent.mass.State;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Constraint
implements Serializable {
    private static final int TABLE_SIZE = 5;
    public static final int AT = 0;
    public static final int ABOVE = 1;
    public static final int BELOW = 2;
    public static final int AFTER = 1;
    public static final int BEFORE = 2;
    private String task;
    private String resource;
    private int start;
    private int duration;
    private int orientation;
    private int priority;
    private float quantity;
    private long id;
    private Hashtable related;

    public Constraint() {
        this.setID(State.getRandom().nextLong());
        this.related = new Hashtable(5);
    }

    public Constraint(String r, float q, int s, int d, int o, int p) {
        this();
        this.setResource(r);
        this.setQuantity(q);
        this.setStart(s);
        this.setDuration(d);
        this.setOrientation(o);
        this.setPriority(p);
    }

    public Constraint(String t, int s, int o, int p) {
        this();
        this.setTask(t);
        this.setStart(s);
        this.setOrientation(o);
        this.setPriority(p);
    }

    public static Constraint parseConstraint(String str) {
        StringTokenizer t = new StringTokenizer(str);
        if (t.countTokens() == 6) {
            return new Constraint(t.nextToken(), Float.valueOf(t.nextToken()).floatValue(), Integer.parseInt(t.nextToken()), Integer.parseInt(t.nextToken()), Integer.parseInt(t.nextToken()), Integer.parseInt(t.nextToken()));
        }
        if (t.countTokens() == 4) {
            return new Constraint(t.nextToken(), Integer.parseInt(t.nextToken()), Integer.parseInt(t.nextToken()), Integer.parseInt(t.nextToken()));
        }
        System.err.println("Error: Constraint parse error (" + str + ")");
        return null;
    }

    public String getTask() {
        return this.task;
    }

    public void setTask(String t) {
        this.task = t;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String r) {
        this.resource = r;
    }

    public float getQuantity() {
        return this.quantity;
    }

    public void setQuantity(float q) {
        this.quantity = q;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int s) {
        this.start = s;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int d) {
        this.duration = d;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int o) {
        this.orientation = o;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int p) {
        this.priority = p;
    }

    public long getID() {
        return this.id;
    }

    public void setID(long i) {
        this.id = i;
    }

    public Hashtable getRelated() {
        return this.related;
    }

    public String toString() {
        if (this.resource != null) {
            return "[Constraint-" + this.id + "] " + this.quantity + " " + this.resource + " (" + this.orientation + ") from " + this.start + " for " + this.duration;
        }
        return "[Constraint-" + this.id + "] " + " perform " + this.task + " (" + this.orientation + ") from " + this.start;
    }
}

