/*
 * Decompiled with CFR 0.152.
 */
package agent.mass;

import agent.base.AgentComponent;
import agent.mass.ConflictListener;
import agent.mass.ConflictRecord;
import agent.mass.Scheduler;
import agent.mass.SimpleTaemsReader;
import agent.mass.State;
import agent.simplest.Log;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import taems.Method;
import taems.Node;
import taems.Schedule;
import taems.ScheduleElement;
import taems.Taems;
import taems.TaskBase;

public class ConflictResolution
extends AgentComponent
implements ConflictListener {
    static final long serialVersionUID = 1234567890L;
    protected Log log;
    protected State state;
    protected Vector resolvers = new Vector();
    protected int FAC_CR;

    public ConflictResolution() {
        this.addDependency("Log");
        this.addDependency("State");
    }

    public void init() {
        this.log = (Log)State.findComponent("Log");
        this.state = (State)State.findComponent("State");
        this.FAC_CR = this.log.getFacilityID(this);
        super.init();
    }

    public void begin() {
        this.addResolver(new NodeReplacementResolver());
        this.addResolver(new PreRescheduleResolver());
        this.addResolver(new RescheduleResolver());
        this.addResolver(new AltScheduleResolver());
    }

    public void addResolver(ConflictListener l) {
        if (!this.resolvers.contains(l)) {
            this.resolvers.addElement(l);
        }
    }

    public void removeResolver(ConflictListener l) {
        this.resolvers.removeElement(l);
    }

    public Enumeration getResolvers() {
        return this.resolvers.elements();
    }

    public Vector conflictRequest(ConflictRecord cr) {
        this.log.log("Performing conflict resoltion analysis", 2, this.FAC_CR);
        Vector results = new Vector();
        for (int i = 10; i >= 0; --i) {
            this.log.log("Checking resolvers for level " + i, 2, this.FAC_CR);
            Enumeration e = this.getResolvers();
            while (e.hasMoreElements()) {
                ConflictListener cl = (ConflictListener)e.nextElement();
                if (cl.getResolverPriority() != i) continue;
                this.log.log("Checking resolver " + cl.toString(), 3, this.FAC_CR);
                Vector v = cl.conflictRequest(cr);
                if (v == null) continue;
                Enumeration ve = v.elements();
                while (ve.hasMoreElements()) {
                    results.addElement(ve.nextElement());
                }
            }
            if (!results.isEmpty()) break;
        }
        return results;
    }

    public void conflictResponse(ConflictRecord cr) {
    }

    public int getResolverPriority() {
        return 0;
    }

    public class AltScheduleResolver
    implements ConflictListener {
        public int getResolverPriority() {
            return 5;
        }

        public Vector conflictRequest(ConflictRecord cr) {
            Vector<ConflictRecord> results = new Vector<ConflictRecord>();
            if (cr.getType() == 0 && cr.getTaems() != null) {
                Enumeration e = cr.getTaems().findNodes((Node)new Method());
                while (e.hasMoreElements()) {
                    Taems n;
                    TaskBase t = (TaskBase)e.nextElement();
                    if (!t.hasFinished() || t.getCurrentQuality() != 0.0f || (n = this.generateAltScheduleStructure(cr.getTaems())) == null) continue;
                    results.add(new ConflictRecord(this, cr, n));
                }
            }
            return results;
        }

        public void conflictResponse(ConflictRecord cr) {
        }

        public Taems generateAltScheduleStructure(Taems t) {
            ConflictResolution.this.log.log("Generating altschedule node structure", 2, ConflictResolution.this.FAC_CR);
            Schedule best = null;
            t = (Taems)t.clone();
            Enumeration e = t.getSchedules();
            block0: while (e.hasMoreElements()) {
                Schedule s = (Schedule)e.nextElement();
                if (s.size() <= 0) continue;
                Enumeration es = s.getElements();
                while (es.hasMoreElements()) {
                    ScheduleElement se = (ScheduleElement)es.nextElement();
                    if (se.getMethod().getStartTime() != Integer.MIN_VALUE) {
                        se.setActualStart(se.getMethod().getStartTime());
                    }
                    if (se.getMethod().getFinishTime() == Integer.MIN_VALUE) continue;
                    se.setActualFinish(se.getMethod().getFinishTime());
                    if (!(se.getMethod().getCurrentQuality() <= 0.0f)) continue;
                    continue block0;
                }
                best = s;
            }
            if (best != null) {
                t.setFirstSchedule(best);
                return t;
            }
            return null;
        }
    }

    public class RescheduleResolver
    implements ConflictListener {
        public int getResolverPriority() {
            return 4;
        }

        public Vector conflictRequest(ConflictRecord cr) {
            Vector<ConflictRecord> results = new Vector<ConflictRecord>();
            if (cr.getType() == 0 && cr.getTaems() != null) {
                Enumeration e = cr.getTaems().findNodes((Node)new Method());
                while (e.hasMoreElements()) {
                    Taems n;
                    TaskBase t = (TaskBase)e.nextElement();
                    if (!t.hasFinished() || t.getCurrentQuality() != 0.0f || (n = this.generateRescheduleStructure(cr.getTaems())) == null) continue;
                    results.add(new ConflictRecord(this, cr, n));
                }
            }
            return results;
        }

        public void conflictResponse(ConflictRecord cr) {
        }

        public Taems generateRescheduleStructure(Taems t) {
            ConflictResolution.this.log.log("Generating reschedule node structure", 2, ConflictResolution.this.FAC_CR);
            State cfr_ignored_0 = ConflictResolution.this.state;
            Scheduler scheduler = (Scheduler)State.findComponent("Scheduler");
            t = (Taems)t.clone();
            t.setScheduleVector(null);
            Vector v = scheduler.evaluateTaems(t, true);
            if (v == null || v.isEmpty()) {
                return null;
            }
            t.setScheduleVector(v);
            return t;
        }
    }

    public class PreRescheduleResolver
    implements ConflictListener {
        SimpleTaemsReader reader = (SimpleTaemsReader)State.findComponent("SimpleTaemsReader");
        String mycode = "PreReschedule";

        public int getResolverPriority() {
            return 6;
        }

        public Vector conflictRequest(ConflictRecord cr) {
            Vector<ConflictRecord> results = new Vector<ConflictRecord>();
            if (cr.getType() == 0 && cr.getTaems() != null) {
                Enumeration e = cr.getTaems().findNodes((Node)new Method());
                block0: while (e.hasMoreElements()) {
                    TaskBase t = (TaskBase)e.nextElement();
                    if (!t.hasFinished() || t.getCurrentQuality() != 0.0f) continue;
                    ConflictResolution.this.log.log("Looking for conflict stuff on " + t.getLabel(), 2, ConflictResolution.this.FAC_CR);
                    while (t != null) {
                        if (t.hasAttribute((Object)"NoQualityException")) {
                            Taems n;
                            String r = (String)t.getAttribute((Object)"NoQualityException");
                            if (!r.startsWith(this.mycode) || (n = this.generatePreRescheduleStructure(cr.getTaems(), r)) == null) continue block0;
                            results.add(new ConflictRecord(this, cr, n));
                            continue block0;
                        }
                        t = t.firstSupertask();
                    }
                }
            }
            return results;
        }

        public void conflictResponse(ConflictRecord cr) {
        }

        public Taems generatePreRescheduleStructure(Taems t, String r) {
            String start;
            StringTokenizer tok = new StringTokenizer(r);
            ConflictResolution.this.log.log("Generating prereschedule node structure " + r, 2, ConflictResolution.this.FAC_CR);
            if (!tok.nextToken().equals(this.mycode)) {
                ConflictResolution.this.log.log("Whoops, this isn't a " + this.mycode + " directive", 1, ConflictResolution.this.FAC_CR);
                return null;
            }
            if (t.numSchedules() <= 0) {
                ConflictResolution.this.log.log("Taems structure " + t.getLabel() + " has no schedule to update", 1, ConflictResolution.this.FAC_CR);
                return null;
            }
            Schedule s = (t = (Taems)t.clone()).getFirstSchedule();
            ScheduleElement el = s.getScheduleElement(start = tok.nextToken());
            if (el == null) {
                ConflictResolution.this.log.log("Could not find start node " + start + " in schedule", 1, ConflictResolution.this.FAC_CR);
                return null;
            }
            int i = s.getScheduleElementIndex(el);
            while (s.size() > i) {
                s.removeScheduleElement(s.getScheduleElement(i));
            }
            Taems nt = this.reader.readTTaems(tok.nextToken());
            Schedule ns = nt.getFirstSchedule();
            int time = (Integer)ConflictResolution.this.state.getProperty("Time");
            Enumeration e = ns.getElements();
            while (e.hasMoreElements()) {
                el = (ScheduleElement)e.nextElement();
                el.setStartTime(el.getStartTime().applyOffset((float)time));
                el.setFinishTime(el.getFinishTime().applyOffset((float)time));
                s.addScheduleElement(el);
            }
            t.setFirstSchedule(s);
            t.retargetSchedules();
            return t;
        }
    }

    public class NodeReplacementResolver
    implements ConflictListener {
        SimpleTaemsReader reader = (SimpleTaemsReader)State.findComponent("SimpleTaemsReader");
        String mycode = "ReplaceNode";

        public int getResolverPriority() {
            return 6;
        }

        public Vector conflictRequest(ConflictRecord cr) {
            Vector<ConflictRecord> results = new Vector<ConflictRecord>();
            if (cr.getType() == 0 && cr.getTaems() != null) {
                Enumeration e = cr.getTaems().findNodes((Node)new Method());
                block0: while (e.hasMoreElements()) {
                    TaskBase t = (TaskBase)e.nextElement();
                    if (!t.hasFinished() || t.getCurrentQuality() != 0.0f) continue;
                    ConflictResolution.this.log.log("Looking for conflict stuff on " + t.getLabel(), 2, ConflictResolution.this.FAC_CR);
                    while (t != null) {
                        if (t.hasAttribute((Object)"NoQualityException")) {
                            Taems n;
                            String r = (String)t.getAttribute((Object)"NoQualityException");
                            if (!r.startsWith(this.mycode) || (n = this.generateReplaceNodeStructure(cr.getTaems(), r)) == null) continue block0;
                            results.add(new ConflictRecord(this, cr, n));
                            continue block0;
                        }
                        t = t.firstSupertask();
                    }
                }
            }
            return results;
        }

        public void conflictResponse(ConflictRecord cr) {
        }

        public Taems generateReplaceNodeStructure(Taems t, String r) {
            StringTokenizer tok = new StringTokenizer(r);
            ConflictResolution.this.log.log("Generating replace node structure " + r, 2, ConflictResolution.this.FAC_CR);
            if (!tok.nextToken().equals(this.mycode)) {
                ConflictResolution.this.log.log("Whoops, this isn't a " + this.mycode + " directive", 1, ConflictResolution.this.FAC_CR);
                return null;
            }
            String onn = tok.nextToken();
            String ntn = tok.nextToken();
            String nnn = tok.nextToken();
            Taems ot = (Taems)t.clone();
            Taems nt = this.reader.readTTaems(ntn);
            Node on = ot.findNode(new Node(onn));
            Node nn = nt.findNode(new Node(nnn));
            if (ot == null || on == null || nn == null) {
                ConflictResolution.this.log.log("Could not generate replace node structure", 0, ConflictResolution.this.FAC_CR);
                return null;
            }
            ConflictResolution.this.log.log("Performing replacement", 2, ConflictResolution.this.FAC_CR);
            Node vn = ot.exciseNode(on);
            String name = nn.getLabel();
            nt.removeNode(nn);
            nn.setLabel(vn.getLabel());
            ot.addNode(nn);
            ot.retargetVirtuals();
            nn.setLabel(name);
            ot.setScheduleVector(null);
            return ot;
        }
    }
}

