/*
 * Decompiled with CFR 0.152.
 */
package agent.mass;

import agent.simplest.Log;
import java.util.StringTokenizer;

public class CondRule {
    protected static Log log;
    protected static int FAC_CONDRULE;
    public static final int UNKNOWN = -9999;
    public static final int PERMANENT = 30000;
    public static final int REMOVE = 100;
    public static final int ADD = 101;
    public static final int REPLACE = 102;
    public static final int MODIFY = 103;
    public static final int GRAMMAR = 200;
    public static final int TAEMS = 201;
    public static final int OBJECTIVE = 300;
    public static final int SUBJECTIVE = 301;
    public static final int CONDITIONED = 302;
    public int start = -9999;
    public int duration = -9999;
    public int action = -9999;
    public int target = -9999;
    public String rule = null;
    public int view = -9999;
    public String type = null;
    public String subtype = null;
    public String src = null;
    public String tgt = null;
    public String node = null;

    public CondRule(String str) {
        StringTokenizer tok = new StringTokenizer(str);
        if (tok.countTokens() < 5) {
            log.log("Error: Conditioning rule syntax error (" + str + ")", 0, FAC_CONDRULE);
            return;
        }
        this.start = Integer.parseInt(tok.nextToken());
        String tmp = tok.nextToken();
        this.duration = tmp.indexOf("*") >= 0 ? 30000 : Integer.parseInt(tmp);
        this.target = this.transTarget(tok.nextToken());
        this.action = this.transAction(tok.nextToken());
        this.view = this.transView(tok.nextToken());
        if (this.target == 200) {
            if (this.action == 102) {
                if (tok.countTokens() == 1) {
                    this.src = tok.nextToken();
                } else {
                    String spot = tok.nextToken();
                    this.rule = str.substring(str.indexOf(spot, str.length()));
                }
            } else if (tok.countTokens() >= 2) {
                this.src = tok.nextToken();
                this.tgt = "";
                while (tok.hasMoreElements()) {
                    this.tgt = this.tgt + tok.nextToken() + " ";
                }
            }
        } else if (this.target == 201) {
            if (tok.countTokens() >= 4) {
                this.type = tok.nextToken();
                this.subtype = tok.nextToken();
                this.src = tok.nextToken();
                this.tgt = tok.nextToken();
            } else if (tok.countTokens() >= 2) {
                this.type = tok.nextToken();
                this.node = tok.nextToken();
            } else {
                log.log("Error: Error parsing taems conditioning rule", 0, FAC_CONDRULE);
            }
        } else {
            log.log("Error: Uknown rule target", 0, FAC_CONDRULE);
            return;
        }
        if (tok.countTokens() > 0) {
            String junk = "";
            while (tok.hasMoreElements()) {
                junk = junk + tok.nextToken();
            }
            log.log("Unrecognized junk at end of rule (" + junk + ")", 0, FAC_CONDRULE);
        }
    }

    public CondRule(int s, int d, int t, int a, int v, String r) {
        this.start = s;
        this.duration = d;
        this.target = t;
        this.action = a;
        this.view = v;
        this.rule = r;
    }

    public CondRule(int s, int d, int t, int a, int v, String ty, String st, String sr, String tg) {
        this.start = s;
        this.duration = d;
        this.target = t;
        this.action = a;
        this.view = v;
        this.type = ty;
        this.subtype = st;
        this.src = sr;
        this.tgt = tg;
    }

    public CondRule(int s, int d, int t, int a, int v, String p1, String p2) {
        this.start = s;
        this.duration = d;
        this.target = t;
        this.action = a;
        this.view = v;
        if (this.target == 200) {
            this.src = p1;
            this.tgt = p2;
        } else {
            this.type = p1;
            this.node = p2;
        }
    }

    public int transAction(String a) {
        if (a.equalsIgnoreCase("REMOVE")) {
            return 100;
        }
        if (a.equalsIgnoreCase("ADD")) {
            return 101;
        }
        if (a.equalsIgnoreCase("REPLACE")) {
            return 102;
        }
        if (a.equalsIgnoreCase("MODIFY")) {
            return 103;
        }
        return -9999;
    }

    public int transTarget(String t) {
        if (t.equalsIgnoreCase("GRAMMAR")) {
            return 200;
        }
        if (t.equalsIgnoreCase("TAEMS")) {
            return 201;
        }
        return -9999;
    }

    public int transView(String v) {
        if (v.equalsIgnoreCase("OBJECTIVE")) {
            return 300;
        }
        if (v.equalsIgnoreCase("SUBJECTIVE")) {
            return 301;
        }
        if (v.equalsIgnoreCase("CONDITIONED")) {
            return 302;
        }
        return -9999;
    }

    public boolean matches(CondRule compare) {
        if (compare.start != -9999 && compare.start != this.start) {
            return false;
        }
        if (compare.duration != -9999 && compare.duration != this.duration) {
            return false;
        }
        if (compare.action != -9999 && compare.action != this.action) {
            return false;
        }
        if (compare.target != -9999 && compare.target != this.target) {
            return false;
        }
        if (compare.view != -9999 && compare.view != this.view) {
            return false;
        }
        if (compare.rule != null && !compare.rule.equalsIgnoreCase(this.rule)) {
            return false;
        }
        if (compare.type != null && !compare.type.equalsIgnoreCase(this.type)) {
            return false;
        }
        if (compare.subtype != null && !compare.subtype.equalsIgnoreCase(this.subtype)) {
            return false;
        }
        if (compare.src != null && !compare.src.equalsIgnoreCase(this.src)) {
            return false;
        }
        if (compare.tgt != null && !compare.tgt.equalsIgnoreCase(this.tgt)) {
            return false;
        }
        return compare.node == null || compare.node.equalsIgnoreCase(this.node);
    }

    public String toString() {
        String str = "[CondRule] (" + this.start + "-" + this.duration + ") [" + this.target + ":" + this.action + "] " + this.view + " ";
        str = this.target == 200 ? (this.rule != null ? str + this.rule : str + " " + this.src + " => " + this.tgt) : (this.target == 201 ? (this.node != null ? str + this.type + " " + this.node : str + this.type + " " + this.subtype + " " + this.src + " " + this.tgt) : str + "unkown");
        return str;
    }
}

