/*
 * Decompiled with CFR 0.152.
 */
package agent.mass;

import agent.base.AgentEvent;
import agent.mass.State;
import agent.simplest.LogViewer;
import agent.simplest.LogViewerEntry;
import agent.simplest.LogViewerEntrySlot;
import agent.simplest.LogViewerFilter;
import agent.simplest.MessageEvent;
import agent.simplest.Observe;
import agent.simplest.Observer;
import agent.simplest.PropertyEventListener;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;
import utilities.Connection;
import utilities.KQMLMessage;
import utilities.Message;

public class Communicate
extends agent.simplest.Communicate
implements PropertyEventListener {
    static final long serialVersionUID = 1234567890L;

    public Communicate() {
        State.addParameterInfo("Host", null, "The ip address of the machine hosting the Mass simultor.", "localhost");
        State.addParameterInfo("Port", null, null, new Integer(25000));
    }

    public void init() {
        super.init();
        if (State.hasComponent("Observe")) {
            Observe observe = (Observe)State.findComponent("Observe");
            observe.addObserver(new Observer("Real Messages Sent"){

                public boolean checkEvent(AgentEvent e) {
                    if (e instanceof MessageEvent && e.getID() == 0) {
                        return !((MessageEvent)e).getMessage().getDestAddr().equalsIgnoreCase("simulator");
                    }
                    return false;
                }
            });
            observe.addObserver(new Observer("Real Messages Received"){

                public boolean checkEvent(AgentEvent e) {
                    if (e instanceof MessageEvent && e.getID() == 1) {
                        return !((MessageEvent)e).getMessage().getSourceAddr().equalsIgnoreCase("simulator");
                    }
                    return false;
                }
            });
        }
    }

    public void begin() {
        super.begin();
        if (State.hasComponent("LogViewer")) {
            LogViewer viewer = (LogViewer)State.findComponent("LogViewer");
            LogViewerFilter filter = viewer.findFilter("Msg Sent");
            if (filter != null) {
                viewer.removeFilter(filter);
            }
            viewer.addFilter(new LogViewerFilter("Msg Sent", false){

                public boolean isMyLogEntry(String s) {
                    if (s.indexOf("(ack pulse)") != -1) {
                        return false;
                    }
                    return s.indexOf("Message Sent: ") != -1;
                }

                public String formatMyLogEntry(String s) {
                    return "From: " + this.getAgent(s) + "\n" + "To: " + this.getTo(s) + "\n" + "Mesg: " + s.substring(s.indexOf(34));
                }

                public void drawToken(Graphics g, int x, int y, LogViewerEntrySlot v) {
                    Color c = g.getColor();
                    if (v.size() == 1) {
                        LogViewerEntry e = (LogViewerEntry)v.firstElement();
                        String to = this.getTo(e.getData());
                        g.setColor(LogViewer.getColor(to));
                    }
                    this.drawTokenType(g, x, y, 0);
                    g.setColor(c);
                }

                public void drawTokenType(Graphics g, int x, int y, int type) {
                    super.drawTokenType(g, x, y, 2);
                }

                public String getTokenType(int type) {
                    switch (type) {
                        case 0: {
                            return "Message Sent (color is destination)";
                        }
                    }
                    return null;
                }

                public String getTo(String s) {
                    int i = s.indexOf("(to ") + 4;
                    return s.substring(i, s.indexOf(41, i));
                }
            });
        }
    }

    public void reset() {
        this.log.log("mass.Communicate does not reset", 1, this.FAC_COM);
    }

    public void open(String host, int port, int type) {
        if (this.state.hasProperty("Host") && host.equals(this.state.getProperty("Host"))) {
            this.log.log("Changing simulator connection type to KQML...", 2, this.FAC_COM);
            type = 1;
        }
        super.open(host, port, type);
        if (this.state.hasProperty("Host") && host.equals(this.state.getProperty("Host"))) {
            Connection c = this.findConnection(host);
            if (c == null) {
                this.log.log("Whoops, looks like there was an error connecting to the simulator (" + host + ":" + port + ").  Quit the agent, and make sure you have started Mass and that it is listening on the correct port before trying again.", 0, this.FAC_COM);
                return;
            }
            this.setDefaultConnection(c);
            this.ready = true;
            KQMLMessage m = new KQMLMessage("register", (Object)"", "simulator");
            m.addField("type", "control");
            this.sendMessage((Message)m);
            String name = (String)this.state.getProperty("Name");
            this.state.setProperty("Name", name + "?");
            this.flushOQueue();
            this.log.log("Connection to simulator established.", 2, this.FAC_COM);
        }
    }

    public boolean ready() {
        if (this.state == null) {
            return false;
        }
        String name = (String)this.state.getProperty("Name");
        return super.ready() && !name.endsWith("?");
    }

    public Connection findConnection(String host) {
        Connection c = this.findDefaultConnection();
        if (c == null) {
            return super.findConnection(host);
        }
        return c;
    }

    public boolean sendMessage(Message m) {
        if (m.getSourceAddr() == null || m.getSourceAddr().equals("")) {
            m.setSourceAddr((String)this.state.getProperty("Name"));
        }
        return super.sendMessage(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean messagePreprocess(Message m, Connection c) {
        this.log.log("messagePreprocess: " + m, 5, this.FAC_COM);
        if (c.getType() != 1) {
            this.log.log("Message received on unknown connection type, handing off to parent.", 4, this.FAC_COM);
            return super.messagePreprocess(m, c);
        }
        String perf = ((KQMLMessage)m).getPerformative();
        String content = (String)m.getContent();
        String type = ((KQMLMessage)m).getField("type");
        m.setReceiveTime(((Integer)this.state.getProperty("Time")).intValue());
        m.setConnection(c);
        if (type == null) {
            type = "";
        }
        if (type.equalsIgnoreCase("control")) {
            if (perf.equalsIgnoreCase("ask")) {
                if (m.contentWord().equalsIgnoreCase("pulse")) {
                    this.log.log("Pulse", 5, this.FAC_COM);
                    this.control.doPulse();
                    return true;
                }
            } else if (perf.equalsIgnoreCase("echo")) {
                KQMLMessage reply = new KQMLMessage("echo", m.getContent(), m.getSourceAddr());
                reply.addField("in-reply-to", "echo");
                this.sendMessage((Message)reply);
            }
            this.log.log("Firing control message", 5, this.FAC_COM);
            this.startFireEvent(new MessageEvent(this, m, c, 1));
            return true;
        }
        Vector vector = this.iqueue;
        synchronized (vector) {
            this.log.log("Queuing message for delivery", 5, this.FAC_COM);
            this.iqueue.addElement(new MessageEvent(this, m, c, 1));
        }
        return false;
    }

    public void messagePostprocess(Message m, Connection c) {
        if (c.getType() != 1) {
            super.messagePostprocess(m, c);
            return;
        }
        this.flushOQueue();
    }
}

