/*
 * Decompiled with CFR 0.152.
 */
package agent.base;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.Beans;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;
import utilities.Log;
import utilities.VFlowLayout;

public class AgentFrame
extends Frame
implements Runnable {
    private String title;
    private Vector compnames;
    private Vector comps = new Vector();
    private Dimension size;
    private boolean show = true;

    public AgentFrame(String t, Vector c) {
        this.title = t;
        this.compnames = c;
        if (System.getProperty("ShowAgentFrame") != null && System.getProperty("ShowAgentFrame").equalsIgnoreCase("false")) {
            this.show = false;
        }
    }

    public void run() {
        this.setTitle(this.title);
        this.makeComponents();
        if (this.show) {
            this.pack();
            this.setVisible(true);
            this.pack();
        }
    }

    public void makeComponents() {
        boolean show = true;
        ClassLoader loader = this.getClass().getClassLoader();
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        Panel p = new Panel();
        p.setBackground(Color.darkGray);
        p.setLayout(new FlowLayout(0, 0, 0));
        Label l = new Label("Java Agent Framework");
        l.setFont(new Font("SansSerif", 1, 10));
        l.setForeground(Color.lightGray);
        p.add(l);
        l.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                ((Component)e.getSource()).setForeground(Color.lightGray);
                JOptionPane.showMessageDialog(null, "The Java Agent Framework\n\nCore architecture written by Bryan Horling,\nwith additional help from Regis Vincent.  Other\ncomponents were developed by their authors.\n\nCopyright 1997-2002\nMulti-Agent Systems Lab\nUniversity of Massachusetts\nhttp://mas.cs.umass.edu/", "The Java Agent Framework", 1);
            }

            public void mouseEntered(MouseEvent e) {
                ((Component)e.getSource()).setForeground(Color.cyan);
            }

            public void mouseExited(MouseEvent e) {
                ((Component)e.getSource()).setForeground(Color.lightGray);
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        this.add((Component)p, "South");
        p = new Panel();
        p.setLayout((LayoutManager)new VFlowLayout(1, 2, 3, true));
        Enumeration e = this.compnames.elements();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            try {
                Log.getDefault().log("Instantiating " + name, 2);
                Object o = Beans.instantiate(loader, name);
                if (o instanceof Component) {
                    Component c = (Component)o;
                    this.comps.add(c);
                    p.add(c);
                    continue;
                }
                Log.getDefault().log("Error: Object " + name + " is not a component", 0);
            }
            catch (IOException ex) {
                Log.getDefault().log("Error: Exception loading component " + name + "\n" + ex, 0);
            }
            catch (ClassNotFoundException ex) {
                Log.getDefault().log("Error: Could not find component " + name + "\n" + ex, 0);
            }
        }
        this.add(p);
    }
}

