/*
 * Decompiled with CFR 0.152.
 */
package agent.base;

import agent.base.AgentEvent;
import agent.base.StringArray;
import agent.simplest.State;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Polygon;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import utilities.Log;

public abstract class AgentComponent
extends Panel
implements Serializable {
    static final long serialVersionUID = 1234567890L;
    private StringArray descriptor;
    private Vector dependencies = new Vector(10);
    private boolean hasgui = true;
    protected static int MIN_WIDTH = 300;
    protected static int MIN_HEIGHT = 23;
    private boolean ev_firing = false;
    private Vector ev_queue = new Vector();
    private Integer ev_lock = new Integer(0);

    public AgentComponent() {
        this.setDescriptor(new StringArray(new String[]{this.getClass().getName()}));
        if (System.getProperty("APPLETFRAME") != null) {
            if (System.getProperty("APPLETFRAME").equalsIgnoreCase("false")) {
                this.setHasGUI(false);
            } else {
                this.setHasGUI(true);
            }
        }
        if (this.hasGUI()) {
            this.setFont(new Font("Dialog", 0, 12));
        }
    }

    public String getDescriptorString() {
        String label = "";
        String[] descriptor = this.getDescriptor().value();
        for (int i = 0; i < descriptor.length; ++i) {
            label = descriptor[i] + " " + label;
        }
        return label;
    }

    public StringArray getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(StringArray d) {
        if (!d.equals(this.descriptor)) {
            State.removeComponent(this);
            this.descriptor = d;
            State.addComponent(this);
        }
    }

    public String[] getDependencies() {
        Enumeration e = this.dependencies.elements();
        String[] deps = new String[this.dependencies.size()];
        int i = 0;
        while (e.hasMoreElements()) {
            deps[i++] = (String)e.nextElement();
        }
        return deps;
    }

    public void addDependency(String dep) {
        if (!this.dependencies.contains(dep)) {
            this.dependencies.insertElementAt(dep, 0);
            if (!State.hasComponent(dep)) {
                Log.getDefault().log("  Unsatisfied dependancy added: " + dep, 3);
            }
        }
    }

    public void init() {
    }

    public void begin() {
    }

    public void end() {
    }

    public void reset() {
    }

    public void pulse() {
    }

    public boolean hasPopupMenu() {
        return false;
    }

    public boolean hasClickAction() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFireEvent(AgentEvent event) {
        this.ev_queue.addElement(event);
        if (this.ev_firing) {
            return;
        }
        Integer n = this.ev_lock;
        synchronized (n) {
            this.ev_firing = true;
            while (!this.ev_queue.isEmpty()) {
                AgentEvent ev = (AgentEvent)this.ev_queue.firstElement();
                this.ev_queue.removeElement(ev);
                this.fireEvent(ev);
            }
            this.ev_firing = false;
        }
    }

    protected void fireEvent(AgentEvent event) {
        Log.getDefault().log("Warning - No-op fireEvent was called.", 1);
    }

    public void setHasGUI(boolean s) {
        this.hasgui = s;
    }

    public boolean hasGUI() {
        return this.hasgui;
    }

    public Dimension getPreferredSize() {
        if (this.getComponentCount() != 0) {
            return super.getPreferredSize();
        }
        String label = this.getDescriptorString();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Dimension d = new Dimension(Math.max(MIN_WIDTH, fm.stringWidth(label) + 12), Math.max(MIN_HEIGHT, fm.getMaxAscent() + fm.getMaxDescent() + 8));
        return d;
    }

    public synchronized void paint(Graphics g) {
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (this.getComponentCount() != 0) {
            super.paint(g);
            return;
        }
        String label = this.getDescriptorString();
        g.setColor(this.getBackground());
        g.setColor(this.getForeground());
        g.setFont(this.getFont());
        g.drawRect(2, 2, width - 4, height - 4);
        FontMetrics fm = g.getFontMetrics();
        g.drawString(label, (width - fm.stringWidth(label)) / 2, (height + fm.getMaxAscent() - fm.getMaxDescent()) / 2);
        if (this.hasPopupMenu()) {
            Polygon p = new Polygon();
            p.addPoint(width - 16, height / 2 - 3);
            p.addPoint(width - 10, height / 2 - 3);
            p.addPoint(width - 13, height / 2 + 3);
            g.fillPolygon(p);
        }
        if (this.hasClickAction()) {
            g.fillOval(10, height / 2 - 3, 6, 6);
        }
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.sizeToFit();
    }

    private void sizeToFit() {
        Dimension d = this.getSize();
        Dimension pd = this.getPreferredSize();
        if (pd.width > d.width || pd.height > d.height) {
            int height;
            int width = d.width;
            if (pd.width > width) {
                width = pd.width;
            }
            if (pd.height > (height = d.height)) {
                height = pd.height;
            }
            this.setSize(width, height);
            Container p = this.getParent();
            if (p != null) {
                ((Component)p).invalidate();
                ((Component)p).validate();
            }
        }
    }
}

